<?php
/**
 * Plugin Name: WooCommerce MomentPay Payment Gateway
 * Plugin URI:  YOUR_PLUGIN_URI
 * Description: Integrates MomentPay payment gateway with WooCommerce.
 * Version:     1.0.0
 * Author:      YOUR_NAME
 * Author URI:  YOUR_AUTHOR_URI
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: woocommerce-momentpay
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Include the MomentPay Gateway class.
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/class-wc-gateway-momentpay.php';

add_action( 'plugins_loaded', 'init_momentpay_gateway' );

function init_momentpay_gateway() {
	if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
		return;
	}

	/**
	 * Add MomentPay Gateway to WooCommerce payment gateways.
	 */
	add_filter( 'woocommerce_payment_gateways', 'add_momentpay_gateway' );
	function add_momentpay_gateway( $methods ) {
		$methods[] = 'WC_Gateway_MomentPay';
		return $methods;
	}
}